 aR  w ` mP9      h	 o_       nSystem-wide$NOLIST

    NAME Intrcept_SysDep_PC

; This module contains routines that may be
; different depending on what machine Interceptor
; is run on.  This module should eventually handle
; both the Compass and the IBM PC.

; THIS IS THE IBM PC & IBM AT VERSION

DGROUP GROUP DATA
CGROUP GROUP CODE

; Exported calls

    PUBLIC CpEnableInterrupt, CpDisableInterrupt
    PUBLIC CpSetInterrupt, CpEndOfInterrupt
    PUBLIC CpMachineID
    PUBLIC WinGetWindowExtent, WinInvertRectangle
    PUBLIC SysDepPatchCalls, SysDepUnPatchCalls
    PUBLIC timeSlice, timerIntSegAddr

    PUBLIC PcDisplayMode
    PUBLIC PcPrepareCursorForTwitch
    PUBLIC PcRestoreCursorFromTwitch
    PUBLIC PcTurnOnTopTwitch
    PUBLIC PcTurnOnBottomTwitch

    EXTRN  charDevAlias: BYTE
$EJECT

; Memory mapped IO address and IO ports

; machine ID

machIDSeg    EQU 0DFF4H
machIDStart  EQU 1

; interrupt ID's

int8087       EQU 0     
intGpib       EQU 1
intKeyboard   EQU 2
intSysTick    EQU 3
intModem      EQU 4     
intBubble     EQU 5     ; Currently not used
intSerial     EQU 6
intRing       EQU 7

; logical to physical mappings for interrupt controller 1

int0          EQU 8     ; mapped as physical 0
int1          EQU 9     ;                    1
int2          EQU 10    ;                    2
int3          EQU 11    ;                    3
int4          EQU 12    ;                    4
int5          EQU 13    ;                    5
int6          EQU 14    ;                    6
int7          EQU 15    ;                    7

; logical to physical mappings for interrupt controller 2
; these are only valid on PC-AT architecture machines

int0Ctlr2     EQU 16    ; mapped as physical 0 (interrupt controller 2)
int1Ctlr2     EQU 17    ;                    1
int2Ctlr2     EQU 18    ;                    2
int3Ctlr2     EQU 19    ;                    3
int4Ctlr2     EQU 20    ;                    4
int5Ctlr2     EQU 21    ;                    5
int6Ctlr2     EQU 22    ;                    6
int7Ctlr2     EQU 23    ;                    7

; glitch interrupt value

intGlitch     EQU 7


; Interrupt Controller 1

interruptEOI    EQU 20h  
intMask         EQU 21h  ; Interrupts Enabled Mask - Ctlr 1
intBase         EQU 08h  ; use interrupts 8 through 15 (decimal) on PC
specificEOIBase EQU 60h

; Interrupt Controller 2

interruptEOI2   EQU 0A0h  
intMask2        EQU 0A1h ; Interrupts Enabled Mask - Ctlr 2
intBase2        EQU 70h
ctlr2IntEOI     EQU 62h  ; Specific EOI Base + Intr Ctlr 2 Cascade interrupt


DATA SEGMENT PUBLIC 'DATA'

timeSlice       DW 55         ; 55 for IBM PC
timerIntSegAddr DW 20H        ; (icw2 + interruptTable (intSysTick)) * 4

cursorType      DW ?
cursorPos       DW ?
saveTwitchChar  DB ?
currTwitchPage  DB ?


DATA ENDS
$EJECT


CODE SEGMENT PUBLIC 'CODE'
     ASSUME CS:CGROUP, DS:DGROUP

; interrupt table
; This table will map a virtual interrupt ID to its real priority mask
; 8 means unused

interruptTable DB 8, 8, 1, 0, 8, 8, 4, 8   ; Logical int IDs
               DB 0, 1, 2, 3, 4, 5, 6, 7   ; Physical int IDs - Controller 1
               DB 0, 1, 2, 3, 4, 5, 6, 7   ; Physical int IDs - Controller 2

; This table is the same as interruptTable except everything is a power of 2

interruptMask  DB 0, 0, 2, 1, 0,  0,  16, 0   ; Logical int IDs
               DB 1, 2, 4, 8, 16, 32, 64, 128 ; Physical int IDs - Contrller 1
               DB 1, 2, 4, 8, 16, 32, 64, 128 ; Physical int IDs - Contrller 2


; variables stored in code segment

; original entrypoint of Rom Bios printer

oldPcPrnOff     DW ?
oldPcPrnSeg     DW ?


;    PopFlags: PROCEDURE 
;
; This routine is required on the 286 in order to pop flags from
; the stack.  This is due to a 286 bug.  
;
PopFlags PROC NEAR
  IRET
PopFlags ENDP
$EJ

;    CpEnableInterrupt : PROCEDURE (interruptID, mode) CLEAN;
;        DCL (interruptID, mode) BYTE;
;
;    This will enable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

mode        EQU BYTE PTR [BP+4]
interruptID EQU BYTE PTR [BP+6]

CpEnableInterrupt PROC NEAR
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID

   MOV  AH, CS:interruptMask[BX]    ; AH = mask
   NOT  AH                          ; prepare for reseting bit

   MOV  DX, intMask                 ; assume interrupt controller 1

   CMP  BL, int0Ctlr2               ; If not for interrupt controller 2
   JB   CpEnableIntHere             ; then no special checks needed

;  MOV  ES, CS:DataFrame
;  CMP  ES:systemType, IBMAT        ; If not on an AT architecture machine
;  JNE  CpEnableIntExit             ; then don't do anything

   MOV  DX, intMask2                ; interrupt controller 2

CpEnableIntHere:
   PUSHF
   CLI
   IN   AL, DX                      ; get current mask
   AND  AL, AH
   OUT  DX, AL                      ; AND then output it

   PUSH CS
   CALL PopFlags

CpEnableIntExit:
   POP  BP
   RET  4
CpEnableInterrupt ENDP

PURGE mode, interruptID
$EJ

;    CpDisableInterrupt : PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will disable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

interruptID EQU BYTE PTR [BP+4]

CpDisableInterrupt PROC NEAR
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID

   MOV  AH, CS:interruptMask[BX]    ; AL = mask

   MOV  DX, intMask                 ; assume interrupt controller 1

   CMP  BL, int0Ctlr2               ; If not for interrupt controller 2
   JB   CpDisableIntHere            ; then no special checks needed

;  MOV  ES, CS:DataFrame
;  CMP  ES:systemType, IBMAT        ; If not on an AT architecture machine
;  JNE  CpDisableIntExit            ; then don't do anything

   MOV  DX, intMask2                ; interrupt controller 2

CpDisableIntHere:
   PUSHF 
   CLI
   IN   AL, DX                      ; get original mask
   OR   AL, AH
   OUT  DX, AL                      ; OR in new one

   PUSH CS
   CALL PopFlags

CpDisableIntExit:
   POP  BP
   RET  2
CpDisableInterrupt ENDP

PURGE interruptID
$EJ

;    CpSetInterrupt : PROCEDURE (interruptID, pRoutine) PTR CLEAN;
;        DCL interruptID BYTE;
;        DCL pRoutine PTR;
;
;    This will set up an interrupt vector and return the previous value.

pRoutine    EQU DWORD PTR [BP+6]
interruptID EQU  BYTE PTR [BP+10]

CpSetInterrupt PROC NEAR
   PUSH DS
   PUSH BP
   MOV  BP, SP

   XOR  BX, BX
   MOV  DS, BX                      ; DS = interrupt vectors

   MOV  BL, interruptID
   MOV  BL, CS:interruptTable[BX]   ; BL = real interrupt number

   MOV  CX, intBase * 4             ; Assume interrupt controller 1

   CMP  interruptID, int0Ctlr2      ; If not for interrupt controller 2
   JB   CpSetIntHere                ; then no special checks needed

;  MOV  ES, CS:DataFrame
;  CMP  ES:systemType, IBMAT        ; If on an AT architecture machine
;  JE   CpSetIntController2         ; then continue

;  MOV  BX, 0FFFFH                  ; Return NULLPTR for old interrupt
;  MOV  ES, BX
;  MOV  BX, 0FH                     ; To indicate error
;  JMP  SHORT CpSetIntExit

CpSetIntController2:
   MOV  CX, intBase2 * 4            ; interrupt controller 2

CpSetIntHere:
   SHL  BX, 1
   SHL  BX, 1                       ; BX := BX * 4

   ADD  BX, CX                      ; Add offset of 1st hardware intr vector

   PUSHF
   CLI                              ; Turn off interrupts
   
   LES  CX, DWORD PTR DS:[BX]       ; get current routine

   PUSH ES                          ; save segment

   LES  DX, pRoutine
   MOV  DS:[BX], DX                 ; save new offset
   MOV  DS:[BX+2], ES               ; save new segment

   POP  ES                          ; return old vector
   MOV  BX, CX

   PUSH CS
   CALL PopFlags

CpSetIntExit:
   POP  BP
   POP  DS
   RET  6
CpSetInterrupt ENDP

PURGE interruptID, pRoutine
$EJ

;    CpEndOfInterrupt : PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will do a specific "end of interrupt" for the given ID
;    It has been modified to work with both Interrupt Controllers (AT)

interruptID EQU BYTE PTR [BP+4]

CpEndOfInterrupt PROC NEAR
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID
   MOV  AL, specificEOIBase
   OR   AL, CS:interruptTable[BX]   ; AL := (real interrupt #) OR AL

   CMP  BL, int0Ctlr2
   JB   CpEndOfInterruptForCtlr1

CpEndOfInterruptForCtlr2:
;  MOV  ES, CS:DataFrame
;  CMP  ES:systemType, IBMAT        ; If not on an AT architecture machine
;  JNE  CpEndOfIntExit              ; then don't do anything

   OUT  interruptEOI2, AL           ; tell the chip
   MOV  AL, ctlr2IntEOI             ; satisfy interrupt that got to 2nd ctlr

CpEndOfInterruptForCtlr1:
   OUT  interruptEOI, AL            ; tell the chip

CpEndOfIntExit:
   POP  BP
   RET  2
CpEndOfInterrupt ENDP

PURGE interruptID
$EJECT

;    CpMachineID: PROCEDURE (pMachineID) CLEAN;
;        DCL pMachineID PTR;
;
;    This will return the 8 byte machine ID

pMachineID EQU DWORD PTR [BP+6]

CpMachineID PROC NEAR
;    PUSH DS
;    PUSH BP
;    MOV  BP, SP

;    LES  DI, pMachineID

;    MOV  AX, machIdSeg
;    MOV  DS, AX                 ; DS:SI ^ machine ID
;    MOV  SI, machIdStart
;    MOV  CX, 8                  ; loop 8 times

CpMachineLoop:
;    MOV  AH, DS:[SI]            ; get 4 bits in high nibble
;    ADD  SI, 2                  ; SI ^ next 4 bits

;    SHR  AH, 1
;    SHR  AH, 1
;    SHR  AH, 1                  ; move into low nibble
;    SHR  AH, 1                  ; high nibble gets zero

;    MOV  AL, DS:[SI]            ; get next 4 bits
;    ADD  SI, 2

;    AND  AL, 0F0H               ; clear low nibble
;    OR   AL, AH                 ; add in low order nibble
;    MOV  ES:[DI], AL            ; store in users buffer
;    INC  DI

;    LOOP CpMachineLoop

;    POP  BP
;    POP  DS
    RET  4
CpMachineID ENDP

PURGE pMachineID
$EJECT

;    WinGetWindowExtent: PROCEDURE (pExtent) CLEAN;
;        DCL pExtent PTR;
;
;    This will return the window extent.

pExtent EQU DWORD PTR [BP+4]

WinGetWindowExtent PROC NEAR
    PUSH BP
    MOV  BP, SP

    LES  BX, pExtent
    MOV  WORD PTR ES:[BX+0], 318 ; Window width
    MOV  WORD PTR ES:[BX+2], 199 ; Window height

    POP  BP
    RET  4
WinGetWindowExtent ENDP


;    Video Routines: PROCEDURE CLEAN

VideoRtns PROC NEAR
    PUSH BP
    INT  10H
    POP  BP
    RET
VideoRtns ENDP
$EJECT

;    WinInvertRectangle: PROCEDURE (pRectangle) CLEAN;
;        DCL pRectangle PTR;
;
;    This will invert a rectangle; given the
;    following conditions.  It must be in the 2nd
;    half of the screen.  The width of the rect
;    must stay within the bounds of a single word.
;    Clipping will not happen.

;    NOTE: This routine should only be called if
;    the video display mode is a graphics mode.  It
;    assumes that the rectangle being inverted is
;    at least 1 pixel wide and 1 pixel long.

pRectangle EQU DWORD PTR [BP+6]
topLeftX   EQU  WORD PTR [BX+0]
topLeftY   EQU  WORD PTR [BX+2]
extentX    EQU  WORD PTR [BX+4]
extentY    EQU  WORD PTR [BX+6]

WinInvertRectangle PROC NEAR
    PUSH BP
    PUSH DS
    MOV  BP, SP

WinInvRectGraphics:
    LDS  BX, pRectangle
    MOV  DX, topLeftY
    XOR  DI, DI

WinInvRectRowLoop:
    MOV  CX, topLeftX
    XOR  SI, SI

WinInvRectColLoop:
    MOV  AH, 13
    CALL VideoRtns
    XOR  AL, 3
    MOV  AH, 12
    CALL VideoRtns

    INC  CX
    INC  SI
    CMP  SI, extentX
    JNE  WinInvRectColLoop

    INC  DX
    INC  DI
    CMP  DI, extentY
    JNE  WinInvRectRowLoop

    POP  DS
    POP  BP
    RET  4
WinInvertRectangle ENDP
$EJECT

; Entry
;  None

; Exit
;  AL = mode
;  AH = num chars per line
;  BH = current page

PcDisplayMode PROC NEAR
    MOV  AH, 15
    CALL VideoRtns
    RET
PcDisplayMode ENDP


; Entry
;  None

; Exit
;  Original cursor state and location is saved
;  Char at twitch location is saved

PcPrepareCursorForTwitch PROC NEAR
    CALL PcDisplayMode
    MOV  currTwitchPage, BH
    MOV  AH, 3
    CALL VideoRtns                ; Get current cursor type and position
    MOV  cursorPos, DX            ; Save old cursor position
    MOV  cursorType, CX           ; Save old cursor type
    OR   CH, 20H
    MOV  AH, 1
    CALL VideoRtns                ; Turn off the cursor
    MOV  DX, 1800H
    MOV  AH, 2
    CALL VideoRtns                ; Move cursor to lower left hand corner
    MOV  AH, 8
    CALL VideoRtns                ; Read char & attr at twitch position
    MOV  saveTwitchChar, AL
    RET
PcPrepareCursorForTwitch ENDP


PcRestoreCursorFromTwitch PROC NEAR
    MOV  AL, saveTwitchChar
    CALL WriteCharAtTwitchPosition
    CALL PcDisplayMode
    MOV  DX, cursorPos
    MOV  AH, 2
    CALL VideoRtns                      ; Move cursor to original position
    MOV  CX, cursorType           ; Get old cursor
    TEST CH, 20H                  ; If cursor was already off
    JNZ  LeaveCursorOff           ; then leave it off

    AND  CH, 0DFH                 ; Turn on cursor

LeaveCursorOff:
    CMP  CL, 67H                  ; If NOT ROM bug version
    JNE  SetCursorOn              ; then use saved mode

    MOV  CX, 0607H                ; Default graphics display cursor mode
    CMP  AL, 7                    ; If not on monochrome display
    JNE  SetCursorOn              ; then use graphics values

    MOV  CX, 0B0CH                ; else use monochrome default cursor mode

SetCursorOn:
    MOV  AH, 1                    ; Set cursor type
    CALL VideoRtns                ; Video Interrupt
    RET
PcRestoreCursorFromTwitch ENDP
$EJECT

PcTurnOnTopTwitch PROC NEAR
    MOV  AL, 16                   ; Right twitch
    CALL WriteCharAtTwitchPosition
    RET
PcTurnOnTopTwitch ENDP


PcTurnOnBottomTwitch PROC NEAR
    MOV  AL, 17                   ; Right twitch
    CALL WriteCharAtTwitchPosition
    RET
PcTurnOnBottomTwitch ENDP


WriteCharAtTwitchPosition PROC NEAR
    MOV  BH, currTwitchPage
    MOV  CX, 1
    MOV  AH, 10
    CALL VideoRtns                ; Write char only at twitch position
    RET
WriteCharAtTwitchPosition ENDP
$EJECT

; System Dependant Patching for Interceptor

; This routine patches the address of the PC Rom
; Bios printer handler in the interrupt vector table.
; This way calls to the printer may be rerouted to the
; printer spooler on Server.

SysDepPatchCalls PROC NEAR

    PUSH DS
    PUSH ES
    PUSH SI
    PUSH AX

	   XOR  AX, AX
    MOV  DS, AX                    ; Interrupt Vectors
    MOV  SI, 17h*4                 ; PC printer interrupt number
    LES  AX, DWORD PTR DS:[SI]     ; PC Rom BIOS Entrypoint
    MOV  CS:oldPcPrnOff, AX
    MOV  CS:oldPcPrnSeg, ES        ; Save old printer entrypoint

    MOV  DS:[SI+0H], OFFSET PcPrnPatch
    MOV  DS:[SI+2H], CS            ; Set new PdtPrn entrypoint

    POP  AX
    POP  SI
    POP  ES
    POP  DS

    RET
SysDepPatchCalls ENDP
$EJECT

; System Dependant UnPatching for Interceptor

; This routine insures that the address patched at
; the public data table entry for the printer is
; the same as the one set by this routine.  If it
; is not, then this routine returns with the carry
; flag set.  Otherwise, it restores the original
; pointer.

; No Calls should be unpatched if any of them
; do not belong to this program.

SysDepUnPatchCalls PROC NEAR
    PUSH DS
    PUSH ES
    PUSH SI
    PUSH AX

    XOR  AX, AX
    MOV  DS, AX                    ; Address of interrupt vectors
    MOV  SI, 17h*4                 ; PC printer interrupt number

    MOV  AX, CS                    ; This progs code segment
    CMP  AX, WORD PTR DS:[SI+2]
    STC                            ; Error
    JNE  SysDepUnPatchCallsExit

    LES  AX, DWORD PTR CS:oldPcPrnOff
    MOV  DS:[SI+0], AX
    MOV  DS:[SI+2], ES             ; Restore Pc Prn interrupt address

    CLC                            ; No error

SysDepUnPatchCallsExit:
    POP  AX
    POP  SI
    POP  ES
    POP  DS

    RET
SysDepUnPatchCalls ENDP
$EJECT

;   PC Rom Bios Printer Patch To Interceptor Printer

; On entry registers determine:

; AH = 0 => print char in AL, return status in AH
;      1 => init printer port
;      2 => return status in AH

; DX = printer ID (0-2)

; On exit

; AH = status (90H for reguest 2, 10H for others)
; All other registers unchanged

PcPrnPatch PROC FAR
    PUSH DS
    PUSH BX
    PUSH AX                        ; save registers

    MOV  AX, SEG DGROUP:timeSlice
    MOV  DS, AX
    MOV  BX, OFFSET charDevAlias
    MOV  AL, DS:[BX+13]            ; if alias prn
    OR   AL, AL                    ; is not set

    POP  AX
    POP  BX
    POP  DS
    JZ   PcPrnGiveBack             ; then ignore

    OR   AH, AH
    JNZ  PcPrnExit

    PUSH DX
    MOV  DL, AL                    ; get char ready to print
    MOV  AH, 5                     ; print a char
    INT  21H                       ; MsDos call
    POP  DX

PcPrnExit:
    CMP  AH, 2
    MOV  AH, 90H
    JE   PcPrnRet

    AND  AH, 10H                   ; error = OK

PcPrnRet:
    IRET

PcPrnGiveBack:
    JMP  DWORD PTR CS:oldPcPrnOff

PcPrnPatch ENDP


CODE ENDS

    END
